#ifndef KERNEL_LIST
#define KERNEL_LIST

#include "cascade_definitions.h"
#include "lbp_cascade_acf.h"
#include "sat_acf.h"

KERNEL_INFO kernelInfoConcat(LBP_CASC_K) (
	"apu_lbp_cascade",
	9,
	__port(__index(0),
		__identifier(LBP_CASC_IN_INTEGR_IMG),
		__attributes(ACF_ATTR_VEC_IN),
		__spatial_dep(1, 0, 1, 0),
		__e0_data_type(d32u),
		__e0_size(1, 1),
		__ek_size(1, 1)),
	__port(__index(1),
		__identifier(LBP_CASC_LINE_IDX),
		__attributes(ACF_ATTR_SCL_OUT_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d16u),
		__e0_size(1, 1),
		__ek_size(1, 1)),
	__port(__index(2),
		__identifier(LBP_CASC_WND_BUF),
		__attributes(ACF_ATTR_VEC_OUT_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d32u),
		__e0_size(1, 1),
		__ek_size(MAX_WINDOW_WIDTH_LBP + 1, 32)),
	__port(__index(3),
		__identifier(LBP_CASC_IN_CASC_SZ_AND_SKIP),
		__attributes(ACF_ATTR_SCL_IN_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d16u),
		__e0_size(1, 1),
		__ek_size(3, 1)),
	__port(__index(4),
		__identifier(LBP_CASC_IN_CASC_FEAT),
		__attributes(ACF_ATTR_SCL_IN_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d08u),
		__e0_size(1, 1),
		__ek_size(10000, 1)),
		//__ek_size(4096, 1)),
	__port(__index(5),
		__identifier(LBP_CASC_IN_CASC_STAGES),
		__attributes(ACF_ATTR_SCL_IN_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d08u),
		__e0_size(1, 1),
		__ek_size(200, 1)),
		//__ek_size(64, 1)),
	__port(__index(6),
		__identifier(LBP_CASC_IN_PIX_SHFT),
		__attributes(ACF_ATTR_SCL_IN_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d08u),
		__e0_size(1, 1),
		__ek_size(64, 1)),
	__port(__index(7),
		__identifier(LBP_CASC_IN_PIX_OFFS),
		__attributes(ACF_ATTR_SCL_IN_STATIC_FIXED),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d08u),
		__e0_size(1, 1),
		__ek_size(64, 1)),
	__port(__index(8),
		__identifier(LBP_CASC_OUT),
		__attributes(ACF_ATTR_VEC_OUT),
		__spatial_dep(0, 0, 0, 0),
		__e0_data_type(d08u),
		__e0_size(1, 1),
		__ek_size(1, 1))
);

KERNEL_INFO kernelInfoConcat(SAT_K) (
	"apu_sat",
   3,
   __port(__index(0),
   __identifier(SAT_KN_IN),
          __attributes(ACF_ATTR_VEC_IN),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
   __port(__index(1),
    __identifier(SAT_KN_OUT),
          __attributes(ACF_ATTR_VEC_OUT),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d32u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
   //TODO: enforce height = 1?
   __port(__index(2),
   __identifier(SAT_KN_OUT_ROW),
          __attributes(ACF_ATTR_VEC_OUT_STATIC),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d32u),
          __e0_size(1, 1),
          __ek_size(1, 1))
);



#endif
